---
generated_at: 2026-01-14 21:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：40-Grant URL検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（5秒以内）**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Webhooks.API/Services/GrantUrlTesterService.cs`
- E-02: `src/Webhooks.API/Services/IGrantUrlTesterService.cs`
- E-03: `src/Webhooks.API/Apis/WebHooksApi.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TestGrantUrl(urlHook, url, token)メソッド | E-02 (5行目) | ○ |
| C-02 | CheckSameOriginで同一オリジン検証 | E-01 (7-11, 37-45行目) | ○ |
| C-03 | Scheme、Host、Portの一致を確認 | E-01 (42-44行目) | ○ |
| C-04 | 不一致時にWarningログ出力 | E-01 (9行目) | ○ |
| C-05 | HTTP OPTIONSメソッド使用 | E-01 (14行目) | ○ |
| C-06 | X-eshop-whtokenヘッダー設定 | E-01 (15行目) | ○ |
| C-07 | HttpClient.SendAsyncで送信 | E-01 (21行目) | ○ |
| C-08 | 例外発生時にWarningログ出力 | E-01 (31行目) | ○ |
| C-09 | レスポンスからトークン取得 | E-01 (22行目) | ○ |
| C-10 | TryGetValuesでヘッダー取得 | E-01 (22行目) | ○ |
| C-11 | 空トークンはnullとして扱う | E-01 (23行目) | ○ |
| C-12 | IsSuccessStatusCodeチェック | E-01 (27行目) | ○ |
| C-13 | トークン一致チェック | E-01 (27行目) | ○ |
| C-14 | IHttpClientFactory使用 | E-01 (3行目) | ○ |
| C-15 | ILogger使用 | E-01 (3行目) | ○ |
| C-16 | WebHooksApiから呼び出し | E-03 (41行目) | ○ |
| C-17 | request.Url, request.GrantUrl, request.Tokenを引数に | E-03 (41行目) | ○ |
| C-18 | 機能No.40がGrant URL検証として定義 | E-04 | ○ |
| C-19 | 画面No.22（Webhook追加画面）が関連 | E-05 | ○ |
| C-20 | 検証処理は5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（5秒以内）は外部通信を含む推定値、プロジェクト固有の要件定義書またはHttpClientタイムアウト設定での確認が必要
  - 候補：非機能要件定義書 / HttpClient設定 / appsettings.json

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Grant URL検証の基本ロジックは十分な根拠あり
- 0: 低リスク - 同一オリジンチェックが実装済み
- 0: 低リスク - トークンエコーバック検証が実装済み
- 1: 中リスク - HttpClientのタイムアウト設定の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GrantUrlTesterService.TestGrantUrlの実装が正しく記載されているか確認
- [ ] CheckSameOriginのオリジン比較ロジックが正しく記載されているか確認
- [ ] X-eshop-whtokenヘッダーの送受信が正しく記載されているか確認
- [ ] WebHooksApiからの呼び出しが正しく記載されているか確認
- [ ] パフォーマンス要件の妥当性を非機能要件と照合
